<?php $__env->startSection('title', 'Read and destroy?'); ?>

<?php
    use App\Models\Note;
    /** @var Note $note */
?>

<?php $__env->startSection('content'); ?>

    <div class="container">
        <div class="row mt-2 mb-4">
            <div class="col-md-8 mx-auto">

                <?php if($note === null): ?>
                    <div class="alert alert-danger mt-5" role="alert">
                        Secret note does not exist, has already been read, or has expired
                    </div>
                <?php else: ?>
                    <h3 class="mt-5">Read and destroy?</h3>
                    <p>You're about to read and destroy the note with id <strong><?php echo e($note->slug); ?></strong>.</p>
                    <form action="<?php echo e(route('note.decrypt', $note->slug)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php if($note->password): ?>

                            <div class="my-3">
                                <input type="password"
                                       class="form-control"
                                       name="decrypt_password"
                                       placeholder="Enter password for the note"
                                       required>
                            </div>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger mt-3" role="alert">
                                    <?php echo e($errors->first()); ?>

                                </div>
                            <?php endif; ?>

                        <?php endif; ?>
                        <input class="btn btn-primary"
                               type="submit"
                               value="Yes, show me the note"
                               onclick="disableButton(this)">
                        <button type="button" class="btn btn-outline-secondary" disabled>No, not now</button>

                    </form>
                <?php endif; ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/secretnotes/resources/views/note/before_watching.blade.php ENDPATH**/ ?>