<?php $__env->startSection('title', 'Create secret notes that will self-destruct after being read'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container">

        <form action="<?php echo e(route('note.create')); ?>" method="POST" id="create_note_form">
            <?php echo csrf_field(); ?>

            <div class="row mt-5">
                <div class="col-md-6 mx-auto">

                    <div class="text-center">
                        <label for="text" class="lh-sm fw-semibold form-label h1 mb-4">New secret note</label>
                    </div>

                    <textarea class="form-control"
                              name="text"
                              id="text"
                              placeholder="Write your note here..."
                              style="height: 160px"></textarea>

                </div>
            </div>

            <div class="row mt-2 mb-4">
                <div class="col-md-6 mx-auto">
                    <div id="textareaHelp" class="form-text">
                        You can create a secret note with <a href="<?php echo e(route('page.note.new')); ?>">additional settings</a>.
                    </div>
                </div>
            </div>

            <div class="row my-5 justify-content-center">
                <div class="col-6">
                    <div class="d-grid">
                        <button id="create_note_form__submit_btn" type="submit" class="btn btn-lg btn-primary">
                            Create note
                        </button>
                    </div>
                </div>
            </div>

        </form>

    </div>

    <?php echo $__env->make('home.cases', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('home.why', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('home.faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/note/create.js')); ?>"></script>

    
    <script>
        $(document).ready(function(){
            $('#create_note_form__submit_btn').prop('disabled',true);
            $('#text').keyup(function(){
                $('#create_note_form__submit_btn').prop('disabled', this.value == "" ? true : false);
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/secretnotes/resources/views/home.blade.php ENDPATH**/ ?>